package w83a.w83aManager;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import w83a.w83aDAO.W83aFactoriaDAO;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aDateUtil;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bResultados.
 */
public class W83aResultados implements W83aIResultados {

	public java.util.Map buscarCabeceraCuadroResultados(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		Map mapa = new HashMap();
		if (!param.getTerritorio().equals("0")){
			param.setFechaHistorico(W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param));
			SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			param.setNumTrabajadores("todos");
			mapa.put("cabecera", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
		}
		else{
			param.setTerritorio(W83aClsConstantes.CONSTANTE_ALAVA);
			String fechahistaraba=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setTerritorio(W83aClsConstantes.CONSTANTE_BIZKAIA);
			String fechahistbizkaia=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setTerritorio(W83aClsConstantes.CONSTANTE_GIPUZKOA);
			String fechahistgipuzkoa=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setFechaHistorico(W83aDateUtil.getInstance().calcularfechamenor(fechahistaraba,fechahistbizkaia,fechahistgipuzkoa));
			SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			param.setTerritorio("todos");
			param.setNumTrabajadores("todos");
			mapa.put("cabecera", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
		}
		return mapa;	
	}
	
public java.util.Map buscarCabeceraCuadroResClasif(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (!param.getTerritorio().equals("0")){
			param.setFechaHistorico(W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param));
			SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			param.setNumTrabajadores("<=49");
			mapa.put("cabeceramenos49", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
			param.setNumTrabajadores(">49");
			mapa.put("cabeceramas49", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
		}
		else{
			param.setTerritorio(W83aClsConstantes.CONSTANTE_ALAVA);
			String fechahistaraba=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setTerritorio(W83aClsConstantes.CONSTANTE_BIZKAIA);
			String fechahistbizkaia=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setTerritorio(W83aClsConstantes.CONSTANTE_GIPUZKOA);
			String fechahistgipuzkoa=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
			param.setFechaHistorico(W83aDateUtil.getInstance().calcularfechamenor(fechahistaraba,fechahistbizkaia,fechahistgipuzkoa));
			SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			param.setTerritorio("todos");
			param.setNumTrabajadores("<=49");
			mapa.put("cabeceramenos49", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
			param.setNumTrabajadores(">49");
			mapa.put("cabeceramas49", W83aFactoriaDAO.getResultadosDAO().w83acabdelegsindconv(param));
		}
		return mapa;	
	}
	
	public java.util.Map buscarCuadroResultados(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		param.setNumTrabajadores("todos");
		if (!param.getTerritorio().equals("0")){
			mapa=W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param);
			mapa.put(param.getTerritorio(),mapa.get("sindicatos"));
			param.setCaso("1");
		}
		else{
			param.setTerritorio("todos");
			mapa=W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param);
			mapa.put("todos",mapa.get("sindicatos"));
			param.setCaso("3");
		}
		mapa.put("delegadosmenorigual49", mapa.get("delegadosmenorigual49"));
		mapa.put("delegadosmenorigual49", mapa.get("delegadosmenorigual49"));
		return mapa;	
	}
	
	public java.util.Map buscarCuadroResClasifMenorIgual49(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (!param.getTerritorio().equals("0")){
			param.setNumTrabajadores("<=49");
			mapa.put(param.getTerritorio()+"|menos49",W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores("<=49");
			mapa.put(param.getTerritorio()+"|menos49",W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
		}
		param.setNumTrabajadores("true");
		return mapa;	
	}
	
	public java.util.Map buscarCuadroResClasifMayor49(w83a.w83aBeans.W83aResultadosBean param) throws Exception{
		
		Map mapa = new HashMap();
		if (!param.getTerritorio().equals("0")){
			param.setNumTrabajadores(">49");
			mapa.put(param.getTerritorio()+"|mas49",W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
			param.setCaso("2");
		}
		else{
			param.setTerritorio("todos");
			param.setNumTrabajadores(">49");
			mapa.put(param.getTerritorio()+"|mas49",W83aFactoriaDAO.getResultadosDAO().buscarCuadroResultados(param));
			param.setCaso("4");
		}
		return mapa;	
	}
	
	public java.util.Map buscarDelegadosConvenio(w83a.w83aBeans.W83aResultadosBean param, boolean contar) throws Exception{
		
		Map general=new HashMap();
		List lista;
//		String sector="";
//        int codconvenio=-1;
//        int codsindicato=-1;
//        String descsindicato="";
//        int numdelegados=0;
//        String descsector="";
//        List sindicatos=new ArrayList();
//        Map convenios=new HashMap();
//        boolean encontrado=false;
//        int posicion=0;
//        String descconvenio="";
//        String deseconvenio="";
//        int totalelectores=0;
//        List empresas = new ArrayList();
//        List centros = new ArrayList();
//        List actas = new ArrayList();
//        List actas2 = new ArrayList();
//        String[] valores;
//        int numvotos=0;
//        int cod=0;
        
       	if (contar&&"0".equals(param.getMin())){
       		SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
    		if (!param.getTerritorio().equals("0")){
        		param.setFechaHistorico(W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param));
        		param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
    		}
    		else{
    			param.setTerritorio(W83aClsConstantes.CONSTANTE_ALAVA);
    			String fechahistaraba=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
    			param.setTerritorio(W83aClsConstantes.CONSTANTE_BIZKAIA);
    			String fechahistbizkaia=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
    			param.setTerritorio(W83aClsConstantes.CONSTANTE_GIPUZKOA);
    			String fechahistgipuzkoa=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
    			param.setFechaHistorico(W83aDateUtil.getInstance().calcularfechamenor(fechahistaraba,fechahistbizkaia,fechahistgipuzkoa));
    			param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
    			param.setTerritorio("0");
    		}
    	}
        
        if (!"true".equals(param.getDetalleCentro())){
        	List numempresasycentros = new ArrayList();
        	if(!contar & (-1!=param.getModo().indexOf("ultimaIt")||(param.getMin().equals(param.getMax())))){
        		numempresasycentros=W83aFactoriaDAO.getResultadosDAO().obtenerNumEmpresasYCentros(param);
        	}
        	lista= W83aFactoriaDAO.getResultadosDAO().buscarDelegadosConvenio(param,contar);   
        	general.put("numempresasycentros", numempresasycentros);
        	general.put("lista", lista);
        	
    		return general;	
        }else{	
        	lista= W83aFactoriaDAO.getResultadosDAO().buscarDelegConvDetCentro(param,contar);       	
        	general.put("lista", lista);
        	
    		return general;		
        }
        
	}
	
	public java.util.List buscarResCentroSindicato(w83a.w83aBeans.W83aResultadosBean param,boolean contar) throws Exception{
		if (param.getFechaHistorico()==null||("").equals(param.getFechaHistorico())){
			if (!param.getTerritorio().equals("0")){
				param.setFechaHistorico(W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param));
				SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			}
			else{
				param.setTerritorio(W83aClsConstantes.CONSTANTE_ALAVA);
				String fechahistaraba=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
				param.setTerritorio(W83aClsConstantes.CONSTANTE_BIZKAIA);
				String fechahistbizkaia=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
				param.setTerritorio(W83aClsConstantes.CONSTANTE_GIPUZKOA);
				String fechahistgipuzkoa=W83aFactoriaDAO.getResultadosDAO().calcularFechaHistorico(param);
				param.setFechaHistorico(W83aDateUtil.getInstance().calcularfechamenor(fechahistaraba,fechahistbizkaia,fechahistgipuzkoa));
				SimpleDateFormat formatter = new SimpleDateFormat(W83aDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				param.setFeHist(formatter.format(W83aDateUtil.getInstance().addMonths(formatter.parse(param.getFechaHistorico()), 1)));
			}
		}
		List lista= W83aFactoriaDAO.getResultadosDAO().buscarResCentroSindicato(param,contar);
		
		return lista;	
	}
	
}